//
//  NSDictionary+MCAdditions.h
//  MCFoundation
//
//  Created by Alykhan Jetha on Thu Jun 12 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface NSDictionary (MCAdditions)

/*!
	@method keyForObjectEqualTo:
	@discussion returns the key for anObj. Checks by calling isEqual as opposed to a ==
*/
- (NSString *)keyForObjectEqualTo:(id)anObj;

// ObjC doesn't return 0.0 if you send a message returning float or double to a nil
- (float)floatForKey:(NSString *)key defaultValue:(float)defaultValue;
- (float)floatForKey:(NSString *)key;
- (double)doubleForKey:(NSString *)key defaultValue:(double)defaultValue;
- (double)doubleForKey:(NSString *)key;

- (id)mcNSNullSafeObjectForKey: (NSString*)key; // if value is NSNull return nil

// Returns YES iff the value is YES, Y, yes, y, or 1.
- (BOOL)boolForKey:(NSString *)key defaultValue:(BOOL)defaultValue;
- (BOOL)boolForKey:(NSString *)key;

// Just to make life easier
- (int)intForKey:(NSString *)key defaultValue:(int)defaultValue;
- (int)intForKey:(NSString *)key;

// This seems more convenient than having to write your own if statement a zillion times
- (id)objectForKey:(NSString *)key defaultObject:(id)defaultObject;

- (id)keyWithValue:(id)aValue;

// the part after the question mark, i.e. Key=Value&AnotherKey=AnotherValue
// Will be encoded with % codes using NSString's stringByAddingPercentEscapes
- (NSString *)urlParameterStringRepresentation;

- (BOOL)hasValueForKey:(NSString *)key;
@end
